# Doriflow Engine - Fluid Simulation for Blender 3D
# Copyright (C) 2024 Doriflow Team
# This software is licensed under the Creative Commons Attribution-NonCommercial 4.0 International License (CC BY-NC 4.0).

# You are free to:
# -Share: Copy and redistribute the material in any medium or format.
# -Adapt: Remix, transform, and build upon the material.

# UNDER THE FOLOWING TERMS:
# -Attribution: You must give appropriate credit, provide a link to the license, and indicate if changes were made.
# -Appropriate credit should include the following:
#   -The original author's name: Doriflow Team
#   -A link to the original source (if applicable).
#   -A link to the full license: https://creativecommons.org/licenses/by-nc/4.0/.
#   -A clear indication of any changes made, such as: "This material has been modified."
# NonCommercial: You may not use the material for commercial purposes.
# Disclaimer:
# -This simulation engine is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. In no event shall the authors be liable for any claim, damages, or other liability arising from the use of this software.

# For more details, refer to the full license text at:
# https://creativecommons.org/licenses/by-nc/4.0/.

#-----------------------------------------------------------------------------------------------------------------------#
bl_info = {
    "name": "Doriflow Engine Demo - Fluid Simulation for Blender 3D",
    "description": "Fluid simulation engine for Blender 4.0 onwards",
    "author": "Doriflow Team",
    "version": (1, 3, 0),
    "location": "Properties > Physics > Doriflow",
    "warning": "",
    "doc_url": "https://www.doriflow.com/tutorial",
    "category": "Animation",
    "support": "COMMUNITY",
    "wiki_url": "",
    "tracker_url": "",
}
import bpy, addon_utils
import platform
import subprocess
import sys
import ensurepip
import os
from . import properties, operators, ui
from .utils import complete_installation
import shutil



from . import properties, operators, ui

packages = [
        ("taichi", "taichi", "1.7.3", "taichi_packages"),
        ("trimesh", "trimesh", None, "trimesh_packages"),  
        ("scipy", "scipy", "1.15.2", "scipy_packages") ,
        ("Pillow", "PIL" , None, "Pillow_packages"),
    ]


def add_dependencies_path():
    addon_path = os.path.dirname(os.path.realpath(__file__))
    packages_path = os.path.join(addon_path, "packages") 
    if addon_path in sys.path:
        sys.path.remove(addon_path)
    sys.path.insert(0, addon_path)
    if os.path.exists(packages_path):
        for subfolder in os.listdir(packages_path):
            subfolder_path = os.path.join(packages_path, subfolder)
            if os.path.isdir(subfolder_path): 
                sys.path.insert(1, subfolder_path)
add_dependencies_path() 
            
def install_missing_packages(packages):
    addon_path = os.path.dirname(os.path.abspath(__file__)) 
    packages_folder = os.path.join(addon_path, "packages")
    if not os.path.exists(packages_folder):
        os.makedirs(packages_folder)
        print(f"📂 Created 'packages' folder at: {packages_folder}")
    else:
        print(f"📂 'packages' folder already exists at: {packages_folder}")
    os.environ["PYTHONNOUSERSITE"] = "1"
    python_version = f"{sys.version_info.major}.{sys.version_info.minor}"
    python_architecture = platform.architecture()[0]
    print(f"🐍 Python version: {python_version}, Architecture: {python_architecture}")
    for package_name, import_name, version, subfolder in packages:
        package_path = os.path.join(packages_folder, subfolder)
        if os.path.exists(package_path):
            try:
                shutil.rmtree(package_path)
                print(f"🧹 Removed old folder: {package_path}")
            except Exception as e:
                print(f"❌ Failed to remove {package_path}: {e}")
        os.makedirs(package_path, exist_ok=True)
        if package_path not in sys.path:
            sys.path.insert(0, package_path)
        print(f"📦 Installing '{package_name}' into {package_path} ...")
        pip_command = [
            sys.executable, "-m", "pip", "install",
            f"{package_name}=={version}" if version else package_name,
            "--target", package_path
        ]
        result = subprocess.run(pip_command, capture_output=True, text=True)
        if result.returncode == 0:
            print(f"✅ Successfully installed '{package_name}' in {package_path}.")
        else:
            print(f"❌ Installation of '{package_name}' failed.\nError: {result.stderr}")


def enable_addon(addon_name):
    if addon_name not in bpy.context.preferences.addons:
        addon_utils.enable(addon_name, default_set=True)


# import bpy
class DoriFlowCompleteInstallation(bpy.types.Operator):
    bl_idname = "doriflow.complete_installation"
    bl_label = "Finalize Solver Dependencies"
    bl_description = ("Click to complete the installation of the Doriflow addon.")


    @classmethod
    def poll(cls, context):
        return True


    def execute(self, context):
        install_missing_packages(packages)
        load_post(None)
        complete_installation()
        add_dependencies_path() 
        return {'FINISHED'}

@bpy.app.handlers.persistent
def load_post(nonedata):
    properties.load_post()

def register():
    enable_addon("space_view3d_modifier_tools")
    properties.register()
    operators.register()
    ui.register()
    bpy.app.handlers.load_post.append(load_post)
    bpy.utils.register_class(DoriFlowCompleteInstallation)
def unregister():
    bpy.app.handlers.load_post.remove(load_post)
    ui.unregister()
    operators.unregister()
    properties.unregister()
    bpy.utils.unregister_class(DoriFlowCompleteInstallation)
