# DoriFlow Engine with Blender's ray-tracing power
# Copyright (C) 2024 Dr Tien Nguyen
# 
# This add-on is licensed under the Creative Commons Attribution-NonCommercial 4.0 International License (CC BY-NC 4.0).
# 
# You are free to:
# - Share: Copy and redistribute the material in any medium or format
# - Adapt: Remix, transform, and build upon the material
# 
# Under the following terms:
# - Attribution: You must give appropriate credit, provide a link to the license, and indicate if changes were made. You may do so in any reasonable manner, but not in any way that suggests the licensor endorses you or your use.
# - NonCommercial: You may not use the material for commercial purposes.
# 
# This add-on is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# 
# For more details, refer to the full license text at <https://creativecommons.org/licenses/by-nc/4.0/>.

#-----------------------------------------------------------------------------------------------------------------------#
import bpy
from . import doriflow_properties, objects_properties, presets_properties, helper_properties


def load_post():
    doriflow_properties.load_post()


def register():
    doriflow_properties.register()
    objects_properties.register()
    presets_properties.register()
    helper_properties.register()


def unregister():
    objects_properties.unregister()
    doriflow_properties.unregister()
    presets_properties.unregister()
    helper_properties.unregister()
