# Doriflow Engine - Fluid Simulation for Blender 3D
# Copyright (C) 2024 Doriflow Team
# This software is licensed under the Creative Commons Attribution-NonCommercial 4.0 International License (CC BY-NC 4.0).

# You are free to:
# -Share: Copy and redistribute the material in any medium or format.
# -Adapt: Remix, transform, and build upon the material.

# UNDER THE FOLOWING TERMS:
# -Attribution: You must give appropriate credit, provide a link to the license, and indicate if changes were made.
# -Appropriate credit should include the following:
#   -The original author's name: Doriflow Team
#   -A link to the original source (if applicable).
#   -A link to the full license: https://creativecommons.org/licenses/by-nc/4.0/.
#   -A clear indication of any changes made, such as: "This material has been modified."
# NonCommercial: You may not use the material for commercial purposes.
# Disclaimer:
# -This simulation engine is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. In no event shall the authors be liable for any claim, damages, or other liability arising from the use of this software.

# For more details, refer to the full license text at:
# https://creativecommons.org/licenses/by-nc/4.0/.

#-----------------------------------------------------------------------------------------------------------------------#
import json
import bpy
from bpy.props import (PointerProperty, BoolProperty, StringProperty)
from bpy.types import PropertyGroup
from . import compute_fluid_properties, compute_mesh_properties


class DoriflowProperties(PropertyGroup):
    compute_fluid: PointerProperty(name="Domain Compute_Fluid Properties", description="", type=compute_fluid_properties.ComputeFluidProperties)
    compute_mesh: PointerProperty(name="Compute Mesh", description="", type=compute_mesh_properties.ComputeMeshProperties)
    show_init_data: BoolProperty(name="Show Initialization Data", default=False)
    render_output_path: bpy.props.StringProperty(
        name="Render Output Path",
        description="Directory where rendered frames will be saved",
        default=""
    )
    render_start_frame: bpy.props.IntProperty(
        name="Render Start Frame",
        description="Frame to start rendering from",
        default=1
    )
    render_end_frame: bpy.props.IntProperty(
        name="Render End Frame",
        description="Frame to end rendering at",
        default=250
    )
    @classmethod
    def register(cls):
        bpy.types.Scene.doriflow = PointerProperty(name='Doriflow Properties', type=cls)

    @classmethod
    def unregister(cls):
        del bpy.types.Scene.doriflow

    def load_post(self):
        self.compute_fluid.load_post()
        self.compute_mesh.load_post()


def load_post():
    bpy.context.scene.doriflow.load_post()


def register():
    compute_fluid_properties.register()
    compute_mesh_properties.register()
    bpy.utils.register_class(DoriflowProperties)


def unregister():
    bpy.utils.unregister_class(DoriflowProperties)
    compute_mesh_properties.unregister()
    compute_fluid_properties.unregister()
