# Doriflow Engine - Fluid Simulation for Blender 3D
# Copyright (C) 2024 Doriflow Team
# This software is licensed under the Creative Commons Attribution-NonCommercial 4.0 International License (CC BY-NC 4.0).

# You are free to:
# -Share: Copy and redistribute the material in any medium or format.
# -Adapt: Remix, transform, and build upon the material.

# UNDER THE FOLOWING TERMS:
# -Attribution: You must give appropriate credit, provide a link to the license, and indicate if changes were made.
# -Appropriate credit should include the following:
#   -The original author's name: Doriflow Team
#   -A link to the original source (if applicable).
#   -A link to the full license: https://creativecommons.org/licenses/by-nc/4.0/.
#   -A clear indication of any changes made, such as: "This material has been modified."
# NonCommercial: You may not use the material for commercial purposes.
# Disclaimer:
# -This simulation engine is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. In no event shall the authors be liable for any claim, damages, or other liability arising from the use of this software.

# For more details, refer to the full license text at:
# https://creativecommons.org/licenses/by-nc/4.0/.

#-----------------------------------------------------------------------------------------------------------------------#
import json
import bpy
from bpy.props import (FloatVectorProperty, FloatProperty, BoolProperty,)
from bpy.types import PropertyGroup

class DoriflowObstacleProperties(PropertyGroup):
    velocity: FloatVectorProperty(
        name="Velocity",
        default=(0.0, 0.0, 0.0),
        subtype='VELOCITY',
        precision=2,
        description="Initial velocity of the obstacle"
    )
    density: FloatProperty(
        name="Density",
        default=500,
        min=10,
        precision=0,
        description="Density of the obstacle"
    )
    
    isFloating: BoolProperty(name="Floating", default=True)


def register():
    bpy.utils.register_class(DoriflowObstacleProperties)


def unregister():
    bpy.utils.unregister_class(DoriflowObstacleProperties)

