# Doriflow Engine - Fluid Simulation for Blender 3D
# Copyright (C) 2024 Doriflow Team
# This software is licensed under the Creative Commons Attribution-NonCommercial 4.0 International License (CC BY-NC 4.0).

# You are free to:
# -Share: Copy and redistribute the material in any medium or format.
# -Adapt: Remix, transform, and build upon the material.

# UNDER THE FOLOWING TERMS:
# -Attribution: You must give appropriate credit, provide a link to the license, and indicate if changes were made.
# -Appropriate credit should include the following:
#   -The original author's name: Doriflow Team
#   -A link to the original source (if applicable).
#   -A link to the full license: https://creativecommons.org/licenses/by-nc/4.0/.
#   -A clear indication of any changes made, such as: "This material has been modified."
# NonCommercial: You may not use the material for commercial purposes.
# Disclaimer:
# -This simulation engine is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. In no event shall the authors be liable for any claim, damages, or other liability arising from the use of this software.

# For more details, refer to the full license text at:
# https://creativecommons.org/licenses/by-nc/4.0/.

#-----------------------------------------------------------------------------------------------------------------------#
from . import  none_ui, fluid_ui, domain_ui, obstacle_ui, keyframed_obstacle_ui, inlet_ui, outlet_ui, grain_ui, \
        DF_1_presets_ui, DF_2_object_management_ui, DF_3_main_compute_ui, DF_4_compute_mesh_ui,\
            DF_5_whitewater_ui, DF_6_render_DoriFlow_final_scene_ui, preferences_ui
import bpy


def Doriflow_APPEND_TO_PHYSICS(self, context):
    view_layer = context.view_layer
    obj = view_layer.objects.active if view_layer.objects.active else None
    column = self.layout.column(align=True)
    split = column.split(factor=0.5)
    column_left = split.column()
    column_right = split.column()

    if obj.doriflow.is_active:
        row = column_right.row(align=True)
        row.operator(
                "doriflow.doriflow_remove",
                text="Doriflow",
                icon='X'
                )

        if obj.doriflow.is_domain():
            row.enabled = True

        is_saved = bool(bpy.data.filepath)
        if not is_saved and obj.doriflow.is_domain():
            hprops = context.scene.doriflow_helper
            box = self.layout.box()
            row = box.row(align=True)
            row.prop(hprops, "unsaved_blend_file_tooltip", icon="ERROR", emboss=False, text="")
            row = row.row(align=True)
            row.alert = True
            row.label(text="Please save the file now. ")


    else:
        column_right.operator(
                "doriflow.doriflow_add",
                text="Doriflow",
                icon='MOD_FLUIDSIM'
                )


def register():
    preferences_ui.register()
    DF_1_presets_ui.register()
    DF_2_object_management_ui.register()
    DF_3_main_compute_ui.register()
    DF_4_compute_mesh_ui.register()
    DF_5_whitewater_ui.register()
    DF_6_render_DoriFlow_final_scene_ui.register()
    domain_ui.register()
    none_ui.register()
    fluid_ui.register()
    obstacle_ui.register()
    keyframed_obstacle_ui.register()
    inlet_ui.register()
    outlet_ui.register()
    grain_ui.register()
    
    bpy.types.PHYSICS_PT_add.append(Doriflow_APPEND_TO_PHYSICS)


def unregister():
    preferences_ui.unregister()
    DF_1_presets_ui.unregister()
    DF_2_object_management_ui.unregister()
    DF_3_main_compute_ui.unregister()
    DF_4_compute_mesh_ui.unregister()
    DF_5_whitewater_ui.unregister()
    DF_6_render_DoriFlow_final_scene_ui.unregister()
    domain_ui.unregister()
    none_ui.unregister()
    fluid_ui.unregister()
    keyframed_obstacle_ui.unregister()
    obstacle_ui.unregister()
    inlet_ui.unregister()
    outlet_ui.unregister()
    grain_ui.unregister()
    bpy.types.PHYSICS_PT_add.remove(Doriflow_APPEND_TO_PHYSICS)
