# Doriflow Engine - Fluid Simulation for Blender 3D
# Copyright (C) 2024 Doriflow Team
# This software is licensed under the Creative Commons Attribution-NonCommercial 4.0 International License (CC BY-NC 4.0).

# You are free to:
# -Share: Copy and redistribute the material in any medium or format.
# -Adapt: Remix, transform, and build upon the material.

# UNDER THE FOLOWING TERMS:
# -Attribution: You must give appropriate credit, provide a link to the license, and indicate if changes were made.
# -Appropriate credit should include the following:
#   -The original author's name: Doriflow Team
#   -A link to the original source (if applicable).
#   -A link to the full license: https://creativecommons.org/licenses/by-nc/4.0/.
#   -A clear indication of any changes made, such as: "This material has been modified."
# NonCommercial: You may not use the material for commercial purposes.
# Disclaimer:
# -This simulation engine is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. In no event shall the authors be liable for any claim, damages, or other liability arising from the use of this software.

# For more details, refer to the full license text at:
# https://creativecommons.org/licenses/by-nc/4.0/.

#-----------------------------------------------------------------------------------------------------------------------#
import bpy
from ..utils import is_installation_complete
from .. import __package__ as base_package


class Doriflow_Addon_Preference(bpy.types.AddonPreferences):
    bl_idname = base_package
    def draw(self, context):
        is_installation_complete_ = is_installation_complete()
        column = self.layout.column(align=True)
        box = column.box()
        if not is_installation_complete_:
            box.label(text="IMPORTANT: Please Complete Installation", icon='ERROR')
            row = box.row(align=True)
            row.alignment = 'LEFT'
            row.label(text="To complete installation of the Doriflow addon, click here: ")
            row.operator("doriflow.complete_installation", icon='MOD_FLUIDSIM')
        else:
            box.label(text="IMPORTANT: Please Complete Installation", icon='ERROR')
            row = box.row(align=True)
            row.alignment = 'LEFT'
            row.label(text="To complete installation of the Doriflow addon, click here: ")
            row.operator("doriflow.complete_installation", icon='MOD_FLUIDSIM')
            
            extra_row = box.row(align=True)
            extra_row.alignment = 'LEFT'
            extra_row.label(text="Installation completed. You will only need to do this once. Enjoy Doriflow!")


def register():
    bpy.utils.register_class(Doriflow_Addon_Preference)


def unregister():
    bpy.utils.unregister_class(Doriflow_Addon_Preference)