# Doriflow Engine - Fluid Simulation for Blender 3D
# Copyright (C) 2024 Doriflow Team
# This software is licensed under the Creative Commons Attribution-NonCommercial 4.0 International License (CC BY-NC 4.0).

# You are free to:
# -Share: Copy and redistribute the material in any medium or format.
# -Adapt: Remix, transform, and build upon the material.

# UNDER THE FOLOWING TERMS:
# -Attribution: You must give appropriate credit, provide a link to the license, and indicate if changes were made.
# -Appropriate credit should include the following:
#   -The original author's name: Doriflow Team
#   -A link to the original source (if applicable).
#   -A link to the full license: https://creativecommons.org/licenses/by-nc/4.0/.
#   -A clear indication of any changes made, such as: "This material has been modified."
# NonCommercial: You may not use the material for commercial purposes.
# Disclaimer:
# -This simulation engine is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. In no event shall the authors be liable for any claim, damages, or other liability arising from the use of this software.

# For more details, refer to the full license text at:
# https://creativecommons.org/licenses/by-nc/4.0/.

#-----------------------------------------------------------------------------------------------------------------------#
import json
from mathutils import Vector
import os
import sys

IS_INSTALLATION_COMPLETE = False 
def format_list(lst, precision=1):
    return [round(x, precision) for x in lst]


def calculate_bounding_box(obj):
    local_bbox_corner_points = [obj.matrix_world @ Vector(corner) for corner in obj.bound_box]
    min_point = Vector(local_bbox_corner_points[0])
    max_point = Vector(local_bbox_corner_points[0])
    for corner in local_bbox_corner_points:
        min_point.x = min(min_point.x, corner.x)
        min_point.y = min(min_point.y, corner.y)
        min_point.z = min(min_point.z, corner.z)
        max_point.x = max(max_point.x, corner.x)
        max_point.y = max(max_point.y, corner.y)
        max_point.z = max(max_point.z, corner.z)
    min_point = Vector([round(coord, 4) for coord in min_point])
    max_point = Vector([round(coord, 4) for coord in max_point])
    return min_point, max_point

def use_blender_env():
    addon_root_directory = os.path.dirname(os.path.dirname(__file__))
    packages_path = os.path.join(addon_root_directory, "packages") 
    if os.path.exists(packages_path):
        subfolders = [packages_path] 
        for subfolder in os.listdir(packages_path):
            subfolder_path = os.path.join(packages_path, subfolder)
            if os.path.isdir(subfolder_path): 
                subfolders.append(subfolder_path)
        pythonpath = os.environ.get("PYTHONPATH", "")
        for subfolder in subfolders:
            if subfolder not in pythonpath:
                pythonpath = subfolder + os.pathsep + pythonpath
            if subfolder not in sys.path:
                sys.path.insert(0, subfolder)
        os.environ["PYTHONPATH"] = pythonpath

def is_installation_complete():
    global IS_INSTALLATION_COMPLETE
    return IS_INSTALLATION_COMPLETE


def complete_installation():
    global IS_INSTALLATION_COMPLETE
    IS_INSTALLATION_COMPLETE = True