# Doriflow Engine - Fluid Simulation for Blender 3D
# Copyright (C) 2024 Doriflow Team
# This software is licensed under the Creative Commons Attribution-NonCommercial 4.0 International License (CC BY-NC 4.0).

# You are free to:
# -Share: Copy and redistribute the material in any medium or format.
# -Adapt: Remix, transform, and build upon the material.

# UNDER THE FOLOWING TERMS:
# -Attribution: You must give appropriate credit, provide a link to the license, and indicate if changes were made.
# -Appropriate credit should include the following:
#   -The original author's name: Doriflow Team
#   -A link to the original source (if applicable).
#   -A link to the full license: https://creativecommons.org/licenses/by-nc/4.0/.
#   -A clear indication of any changes made, such as: "This material has been modified."
# NonCommercial: You may not use the material for commercial purposes.
# Disclaimer:
# -This simulation engine is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. In no event shall the authors be liable for any claim, damages, or other liability arising from the use of this software.

# For more details, refer to the full license text at:
# https://creativecommons.org/licenses/by-nc/4.0/.

#-----------------------------------------------------------------------------------------------------------------------#
import json

class SimConfig:
    def __init__(self, scene_file_path) -> None:
        self.config = None
        with open(scene_file_path, "r") as f:
            self.config = json.load(f)
        print(self.config)
    def get_domain(self, name=None):
        domain_config = self.config.get("Domain", {})
        if name:
            return domain_config.get(name)
        return domain_config
    
    def get_emitters(self):
        if "InletObjects" in self.config:
            return self.config["InletObjects"]
        else:
            return []
        
    def get_emitter_gas(self):
        if "InletGasObjects" in self.config:
            return self.config["InletGasObjects"]
        else:
            return []

    def get_rigid_bodies(self):
        if "RigidBodies" in self.config:
            return self.config["RigidBodies"]
        else:
            return []
    def get_keyframed_obstacles(self):
        if "KeyframedObstacles" in self.config:
            return self.config["KeyframedObstacles"]
        else:
            return []
    def get_fluid_blocks(self):
        if "FluidBlocks" in self.config:
            return self.config["FluidBlocks"]
        else:
            return []
    def get_gas_objects(self):
        if "GasObjects" in self.config:
            return self.config["GasObjects"]
        else:
            return []
    def get_inlet_objects(self):
        if "InletObjects" in self.config:
            return self.config["InletObjects"]
        else:
            return []
    def get_grain_objects(self):
        if "GrainObjects" in self.config:
            return self.config["GrainObjects"]
    def get_fluid_single(self, property_name):
        if "FluidBlocks" in self.config:
            for block in self.config["FluidBlocks"]:
                if property_name in block:
                    return block[property_name]
        return None
    def get_rigid_single(self, property_name, object_id):
        if "RigidBodies" in self.config:
            for block in self.config["RigidBodies"]:
                if "objectId" in block and block["objectId"] == object_id and property_name in block:
                    return block[property_name]
        return None
    def get_keyframed_single(self, property_name, object_id):
        if "KeyframedObstacles" in self.config:
            for block in self.config["KeyframedObstacles"]:
                if "objectId" in block and block["objectId"] == object_id and property_name in block:
                    return block[property_name]
                
    def get_inlet_single(self, property_name, object_id):
        if "InletObjects" in self.config:
            for block in self.config["InletObjects"]:
                if "objectId" in block and block["objectId"] == object_id and property_name in block:
                    return block[property_name]
        return None
    def get_grain_single(self, property_name, object_id):
        if "GrainObjects" in self.config:
            for block in self.config["GrainObjects"]:
                if "objectId" in block and block["objectId"] == object_id and property_name in block:
                    return block[property_name]
        return None
