# Doriflow Engine - Fluid Simulation for Blender 3D
# Copyright (C) 2024 Doriflow Team
# This software is licensed under the Creative Commons Attribution-NonCommercial 4.0 International License (CC BY-NC 4.0).

# You are free to:
# -Share: Copy and redistribute the material in any medium or format.
# -Adapt: Remix, transform, and build upon the material.

# UNDER THE FOLOWING TERMS:
# -Attribution: You must give appropriate credit, provide a link to the license, and indicate if changes were made.
# -Appropriate credit should include the following:
#   -The original author's name: Doriflow Team
#   -A link to the original source (if applicable).
#   -A link to the full license: https://creativecommons.org/licenses/by-nc/4.0/.
#   -A clear indication of any changes made, such as: "This material has been modified."
# NonCommercial: You may not use the material for commercial purposes.
# Disclaimer:
# -This simulation engine is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. In no event shall the authors be liable for any claim, damages, or other liability arising from the use of this software.

# For more details, refer to the full license text at:
# https://creativecommons.org/licenses/by-nc/4.0/.

#-----------------------------------------------------------------------------------------------------------------------#
import bpy
from . import compute_fluid_operators, import_all_particles_operators, json_operators, object_management_operators,\
    error_operators, presets_operators,\
    import_motion_operators, helper_operators,\
             voxelization_geometry_node_operators, mesh_geometry_node_operators, preferences_operators,\
                grain_geometry_node_operators

def register():
    json_operators.register()
    compute_fluid_operators.register()
    object_management_operators.register()
    error_operators.register()
    presets_operators.register()
    import_motion_operators.register()
    voxelization_geometry_node_operators.register()
    mesh_geometry_node_operators.register()
    import_all_particles_operators.register()
    helper_operators.register()
    preferences_operators.register()
    grain_geometry_node_operators.register()

def unregister():
    compute_fluid_operators.unregister()
    json_operators.unregister()
    object_management_operators.unregister()
    error_operators.unregister()
    presets_operators.unregister()
    import_motion_operators.unregister()
    mesh_geometry_node_operators.unregister()
    voxelization_geometry_node_operators.unregister()
    import_all_particles_operators.unregister()
    helper_operators.unregister()
    preferences_operators.unregister()
    grain_geometry_node_operators.unregister()
