# Doriflow Engine - Fluid Simulation for Blender 3D
# Copyright (C) 2024 Doriflow Team
# This software is licensed under the Creative Commons Attribution-NonCommercial 4.0 International License (CC BY-NC 4.0).

# You are free to:
# -Share: Copy and redistribute the material in any medium or format.
# -Adapt: Remix, transform, and build upon the material.

# UNDER THE FOLOWING TERMS:
# -Attribution: You must give appropriate credit, provide a link to the license, and indicate if changes were made.
# -Appropriate credit should include the following:
#   -The original author's name: Doriflow Team
#   -A link to the original source (if applicable).
#   -A link to the full license: https://creativecommons.org/licenses/by-nc/4.0/.
#   -A clear indication of any changes made, such as: "This material has been modified."
# NonCommercial: You may not use the material for commercial purposes.
# Disclaimer:
# -This simulation engine is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. In no event shall the authors be liable for any claim, damages, or other liability arising from the use of this software.

# For more details, refer to the full license text at:
# https://creativecommons.org/licenses/by-nc/4.0/.

#-----------------------------------------------------------------------------------------------------------------------#
import bpy, textwrap
from bpy.props import (StringProperty, IntProperty)


class DoriflowDisplayError(bpy.types.Operator):
    bl_idname = "doriflow.display_error"
    bl_label = ""
    bl_description = ""
    error_message: StringProperty()
    error_description: StringProperty()
    popup_width: IntProperty(default=400)

    def draw(self, context):
        row = self.layout.row()
        row.alignment = 'CENTER'
        row.label(text=self.error_message, icon='ERROR')
        if self.error_description:
            text_list = textwrap.wrap(self.error_description, width=self.popup_width//6)
            column = self.layout.column(align=True)
            column.separator()
            column.separator()
            for idx,line in enumerate(text_list):
                column.label(text=line)
        self.layout.separator()
        self.layout.separator()

    def execute(self, context):
        self.report({'INFO'}, self.error_message)
        if self.error_description:
            self.report({'INFO'}, self.error_description)
        self.error_message = ""
        self.error_description = ""
        self.popup_width = 400
        return {'FINISHED'}
    def invoke(self, context, event):
        return context.window_manager.invoke_props_dialog(self, width=self.popup_width)


def register():
    bpy.utils.register_class(DoriflowDisplayError)


def unregister():
    bpy.utils.unregister_class(DoriflowDisplayError)
