# Doriflow Engine - Fluid Simulation for Blender 3D
# Copyright (C) 2024 Doriflow Team
# This software is licensed under the Creative Commons Attribution-NonCommercial 4.0 International License (CC BY-NC 4.0).

# You are free to:
# -Share: Copy and redistribute the material in any medium or format.
# -Adapt: Remix, transform, and build upon the material.

# UNDER THE FOLOWING TERMS:
# -Attribution: You must give appropriate credit, provide a link to the license, and indicate if changes were made.
# -Appropriate credit should include the following:
#   -The original author's name: Doriflow Team
#   -A link to the original source (if applicable).
#   -A link to the full license: https://creativecommons.org/licenses/by-nc/4.0/.
#   -A clear indication of any changes made, such as: "This material has been modified."
# NonCommercial: You may not use the material for commercial purposes.
# Disclaimer:
# -This simulation engine is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. In no event shall the authors be liable for any claim, damages, or other liability arising from the use of this software.

# For more details, refer to the full license text at:
# https://creativecommons.org/licenses/by-nc/4.0/.

#-----------------------------------------------------------------------------------------------------------------------#
import json
import bpy
from bpy.props import (BoolProperty, IntProperty, StringProperty)
from bpy.types import PropertyGroup


class ComputeFluidProperties(PropertyGroup):
    output_directory_path: StringProperty(default='')
    initialization_data_file_path: StringProperty(name="Initialization Data File Path", default='')
    is_simulation_running: BoolProperty(default=False)
    is_compute_fluid_initialized: BoolProperty(default=False)
    is_compute_fluid_paused: BoolProperty(default=False)
    is_compute_fluid_stopped: BoolProperty(default=False)
    num_compute_fluid_frames: IntProperty(default=0)
    num_compute_fluidd_vtks: IntProperty(default=0)
    num_total_frames: IntProperty(default=0)
    is_safe_to_exit: BoolProperty(default=False)
    is_one_button_compute_running: BoolProperty(default=False)
    is_one_button_compute_terminated: BoolProperty(default=False)
    info_for_one_button: StringProperty(name="Info for One Button", default='Start Doriflow Simulation')
    def reset(self):
        self.is_simulation_running = False
        self.is_compute_fluid_initialized = False
        self.is_compute_fluid_paused = False
        self.is_safe_to_exit = False
        self.is_compute_fluid_stopped = False
        self.is_one_button_compute_running = False
        self.is_one_button_compute_terminated = False
        self.info_for_one_button = 'Start Doriflow Simulation'

    def load_post(self):
        self.reset()


def register():
    bpy.utils.register_class(ComputeFluidProperties)


def unregister():
    bpy.utils.unregister_class(ComputeFluidProperties)