# Doriflow Engine - Fluid Simulation for Blender 3D
# Copyright (C) 2024 Doriflow Team
# This software is licensed under the Creative Commons Attribution-NonCommercial 4.0 International License (CC BY-NC 4.0).

# You are free to:
# -Share: Copy and redistribute the material in any medium or format.
# -Adapt: Remix, transform, and build upon the material.

# UNDER THE FOLOWING TERMS:
# -Attribution: You must give appropriate credit, provide a link to the license, and indicate if changes were made.
# -Appropriate credit should include the following:
#   -The original author's name: Doriflow Team
#   -A link to the original source (if applicable).
#   -A link to the full license: https://creativecommons.org/licenses/by-nc/4.0/.
#   -A clear indication of any changes made, such as: "This material has been modified."
# NonCommercial: You may not use the material for commercial purposes.
# Disclaimer:
# -This simulation engine is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. In no event shall the authors be liable for any claim, damages, or other liability arising from the use of this software.

# For more details, refer to the full license text at:
# https://creativecommons.org/licenses/by-nc/4.0/.

#-----------------------------------------------------------------------------------------------------------------------#
import json
import bpy
from .domain_ui import DORIFLOW_PT_DomainTypePanel
from .fluid_ui import DORIFLOW_PT_FluidTypePanel
from .obstacle_ui import DORIFLOW_PT_ObstacleTypePanel
from .keyframed_obstacle_ui import DORIFLOW_PT_KeyframedObstacleTypePanel
from .inlet_ui import DORIFLOW_PT_InletTypePanel
from .outlet_ui import DORIFLOW_PT_OutletTypePanel
from .grain_ui import DORIFLOW_PT_GrainTypePanel

class DORIFLOW_PT_AssignPanel(bpy.types.Panel):
    bl_label = "[Doriflow] -1- Initialization"
    bl_space_type = 'PROPERTIES'
    bl_region_type = 'WINDOW'
    bl_category = 'Doriflow'
    bl_context = "physics"
    bl_idname = "OBJECT_PT_initialization_ui"
    bl_options = {'DEFAULT_CLOSED'}
    bl_order = 9

    @classmethod
    def poll(cls, context):
        return context.object is not None and context.object.doriflow.object_type in {'TYPE_DOMAIN', 'TYPE_FLUID', 'TYPE_OBSTACLE',\
             'TYPE_KEYFRAMED_OBSTACLE', 'TYPE_INLET' , 'TYPE_OUTLET', 'TYPE_GRAIN' , 'TYPE_NONE'} and context.object.doriflow.is_active

    def draw(self, context):
        layout = self.layout
        box = layout.box()
        obj = context.object
        box.label(text="Assign:")
        row = box.row()
        row.operator("doriflow.assign_domain", text="Domain", depress=obj.doriflow.object_type == 'TYPE_DOMAIN')
        row.operator("doriflow.assign_fluid", text="Fluid", depress=obj.doriflow.object_type == 'TYPE_FLUID')
        row.operator("doriflow.assign_obstacle", text="Solid", depress=obj.doriflow.object_type == 'TYPE_OBSTACLE')
        row.label(text="Keyframed Solid")
        row.label(text="Inlet")
        row.operator("doriflow.assign_grain", text="Grain", depress=obj.doriflow.object_type == 'TYPE_GRAIN')
        row.operator("doriflow.assign_none", text="None", depress=obj.doriflow.object_type == 'TYPE_NONE')

def register():
    bpy.utils.register_class(DORIFLOW_PT_AssignPanel)


def unregister():
    bpy.utils.unregister_class(DORIFLOW_PT_AssignPanel)
